/******************************************************************************/
#include "stdafx.h"
#include <EsenthelEngine/EsenthelEngine.h>
/******************************************************************************/
Mesh   *chr   ; // character mesh
Gfx    *main  , // main   blood texture
       *single; // single blood texture
BloodFx blood ; // blood particle effect
/******************************************************************************/
void InitPre()
{
   App.name="Blood Effect";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE;
   IOPath="../data/";
   PakAdd("engine.pak",NULL);

   Cam.dist=3;
   D.full(1).hpRt(true);
}
/******************************************************************************/
Bool Init()
{
   Sky.set();

   chr=Meshs("obj/chr/human/0.mesh");

   main  =Gfxs("gfx/particle/blood/0.gfx");
   single=Gfxs("gfx/particle/blood/1.gfx");

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1f,100,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT));

   // enable blood effect
   if(Kb.bp(KB_SPACE)) // on space
      blood.create(main,single,0xFF800000,60,Vec(0,1,0),Vec(1.6,0,0)); // create blood effect

   // update blood effect
   blood.update();

   return true;
}
/******************************************************************************/
Void Render()
{
   switch(Renderer())
   {
      case RM_SOLID:
      case RM_SHD_MAP:
         chr->draw(Matrix(2).rotateY(PI)); // draw character mesh
      break;

      case RM_LIGHT:
         LightPoint(5,Vec(0,1,-1)).add();
      break;

      case RM_PRT_BLN:
         blood.draw(); // draw Blood Effect in Particle Blending mode
      break;
   }
}
void Draw()
{
   Renderer(Render);
   D.text(0,0.9,"Press Space to enable Blood Effect");
}
/******************************************************************************/
